/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DeliverSmResp;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.ServerResponseHandler;
import org.jsmpp.session.state.SMPPServerSessionBound;
import org.jsmpp.session.state.SMPPServerSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SMPPServerSessionBoundRX
extends SMPPServerSessionBound
implements SMPPServerSessionState {
    private static final Logger logger = LoggerFactory.getLogger(SMPPServerSessionBoundRX.class);

    SMPPServerSessionBoundRX() {
    }

    @Override
    public SessionState getSessionState() {
        return SessionState.BOUND_RX;
    }

    @Override
    public void processDeliverSmResp(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        SMPPServerSessionBoundRX.processDeliverSmResp0(pduHeader, pdu, responseHandler);
    }

    @Override
    public void processQuerySm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    @Override
    public void processSubmitSm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    @Override
    public void processSubmitMulti(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    @Override
    public void processCancelSm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    @Override
    public void processReplaceSm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    static final void processDeliverSmResp0(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            DeliverSmResp resp = pduDecomposer.deliverSmResp(pdu);
            pendingResp.done(resp);
        } else {
            logger.warn("No request with sequence_number {} found", (Object)pduHeader.getSequenceNumber());
        }
    }
}

