/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class UnixSpecialDirs {
    public static final String XDG_DESKTOP_DIR = "XDG_DESKTOP_DIR";
    public static final String XDG_DOCUMENTS_DIR = "XDG_DOCUMENTS_DIR";
    public static final String XDG_DOWNLOAD_DIR = "XDG_DOWNLOAD_DIR";
    private static Map<String, File> unixDirectories;

    public static synchronized File getDirectory(String id) {
        if (unixDirectories == null) {
            unixDirectories = new HashMap<String, File>();
            try {
                File dirConfigFile = new File(Util.getUserHome(), ".config/user-dirs.dirs");
                if (dirConfigFile.isFile()) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dirConfigFile), StandardCharsets.UTF_8));
                    String line = reader.readLine();
                    while (line != null) {
                        int equalPos;
                        if (!(line = line.trim()).startsWith("#") && (equalPos = line.indexOf("=")) > -1) {
                            String name = line.substring(0, equalPos);
                            String value = line.substring(equalPos + 1);
                            if (value.startsWith("\"")) {
                                value = value.substring(1);
                            }
                            if (value.endsWith("\"")) {
                                value = value.substring(0, value.length() - 1);
                            }
                            value = value.replaceAll("\\$HOME", Util.getUserHome());
                            unixDirectories.put(name, new File(value));
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                }
            }
            catch (Throwable t) {
                Logger.getInstance().log(t);
            }
        }
        return unixDirectories.get(id);
    }
}

